function [Draws, Prog] = Gibbs04(ProgIn, s, par, Priors, DisplayLevel)
%	Draws = Gibbs04(Prog, s, par, Priors, DisplayLevel)
%	Generate Gibbs draws for Roll model.
% 	Inputs:
% 	Prog.nDraw	number of sweeps
% 	Prog.Draw_q	Boolean: whether or not to simulate trade direction indicators.
% 				Set to false for debugging
% 	s	Segment array
% 		Each segment consists of a sequence of security prices with no missing values.
% 		Note: a quote midpoint reported as a negative price will have q=0. This is NOT a missing value
% 	s(i).p	prices
% 	s(i).q	trade direction indicators
%
% 	par.c	starting value for c
% 	par.sdu	starting value of sdu
% 	DisplayLevel	type of diagnostics to report.
% 	

if nargin<5; DisplayLevel=1; end;
Prog = ProgIn;
randn('state',1234567);	%   Initialize random number generators
rand ('state',5123456);

tic;	%	start a timer (used to track execution times)
for i=1:length(s); %	compute implied efficient prices and price changes
	s(i).m = s(i).p - par.c*s(i).q;
	a(i).dp = diff(s(i).p); 
end;
dp = [a.dp];

%	Initialize vectors that will, on return, contain the simulated parameter values
Draws.sdu = zeros(1,Prog.nDraw);
Draws.c = zeros(1,Prog.nDraw);
%	cPriorDraw is a Boolean array. An entry is set to true if the draw for c on the sweep was from the prior.
Draws.cPriorDraw = zeros(1,Prog.nDraw);

for iDraw=1:Prog.nDraw
    
    npr = 100;	% Print a message every npr draws (to help user judge timing).
    if DisplayLevel==1 & mod(iDraw,npr)==0; fprintf(1,'%6d',iDraw); end;
    if DisplayLevel==1 & (mod(iDraw,10*npr)==0 | iDraw==Prog.nDraw); fprintf(1,'\n'); end; 
    
    if DisplayLevel>1,
	    disp(['iDraw=' num2str(iDraw) ' par.c=' num2str(par.c) ' par.varu=' num2str(par.varu)])
    end
    
    for i=1:length(s);
        if Prog.Draw_q;     %   Make draws of q.
            [s(i).m, s(i).q] = mqDraw(s(i).p, s(i).m, s(i).q, par.c, par.varu);
        else
            s(i).m = s(i).p - par.c*s(i).q;
        end
        a(i).dq = diff(s(i).q);
    end
    dq = [a.dq];
    	
    Posterior = BayesSimpleRegressionUpdate(Priors.Coeff, dp', dq', par.varu);     % update regression posterior
    if Posterior.ret~=0	%	check for error return
	    dq
	    [s.q]
	    error('zzz')
    end
    Draws.cPriorDraw(iDraw) = Posterior.ret;
    par.c = RandNormT(Posterior.mu, sqrt(Posterior.cov), 0, inf);   % truncated draw of new c
    Draws.c(iDraw) = par.c;
    
    u = (dp') - (dq')*par.c;  %   Draw a new sdu
    Posterior = BayesVarianceUpdate(Priors.varu, u);
    par.varu = InverseGammaRnd(Posterior.alpha, Posterior.beta);
    Draws.sdu(iDraw) = sqrt(par.varu);
    
end	%	End of iDraw loop.

Prog.ElapsedTime = toc;

return

%__________________________________________________________________________

function [mNew,qNew] = mqDraw(p, m, q, c, varu)
%	Make new draws for q (and, therefore, m)
mNew = m;
T = length(mNew);
qNew = q;
ranu = rand(1,T);
for t=1:T
	if qNew(t)==0; continue; end;	% if q(t)==0, the observation corresponds to a quote midpoint. DON'T make new draw.
    if t==1
        mu = mNew(2); 
        var = varu;
    elseif t==T
        mu = mNew(T-1);
        var = varu;
    else
        mu = (mNew(t-1) + mNew(t+1))/2.;
        var = varu/2.;
    end
    f = p(t)+c-mu;
    PSell = exp(-f*f/(2*var));
    f = p(t)-c-mu;
    PBuy = exp(-f*f/(2*var));
    PBuy = PBuy/(PBuy+PSell);
	qNew(t) = 1 - 2*(ranu(t)>PBuy);
    mNew(t) = p(t) - qNew(t)*c;
end
return